// test_PSMDlg.cpp : implementation file
//

#include "stdafx.h"
#include "test_PSM.h"
#include "test_PSMDlg.h"
#include "ComPort.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTest_PSMDlg dialog

CTest_PSMDlg::CTest_PSMDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTest_PSMDlg::IDD, pParent)
{
	Comtype=0;
	Port="Com1";
	Baud="9600";
	//{{AFX_DATA_INIT(CTest_PSMDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_device = NULL; // Initialize the GPIB device object pointer to NULL
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CTest_PSMDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT2, ST_Mem);
    DDX_Control(pDX, IDC_EDIT3, END_Mem);
    DDX_Control(pDX, IDC_EDIT4, Cycle);
	DDX_Control(pDX, IDC_EDIT1, GPIB_addr);
	DDX_Control(pDX,IDC_COMBO1,m_port);
	DDX_Control(pDX,IDC_COMBO2,m_baud);
	//{{AFX_DATA_MAP(CTest_PSMDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTest_PSMDlg, CDialog)
	//{{AFX_MSG_MAP(CTest_PSMDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_CBN_SELCHANGE(IDC_COMBO1, OnSelchangeCombo1)
	ON_CBN_SELCHANGE(IDC_COMBO2, OnSelchangeCombo2)
	ON_BN_CLICKED(IDC_RADIO1, OnRadio1)
	ON_BN_CLICKED(IDC_RADIO2, OnRadio2)
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_RADIO3, OnRadio3)
	ON_BN_CLICKED(IDC_RADIO4, OnRadio4)
	ON_BN_CLICKED(IDC_RADIO5, OnRadio5)
	ON_BN_CLICKED(IDC_RADIO6, OnRadio6)
	ON_EN_CHANGE(IDC_EDIT2, OnChangeEdit2)
	ON_EN_CHANGE(IDC_EDIT3, OnChangeEdit3)
	ON_EN_CHANGE(IDC_EDIT4, OnChangeEdit4)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTest_PSMDlg message handlers

BOOL CTest_PSMDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.
	GPIB_addr.SetWindowText("8");
	ST_Mem.SetWindowText("00");
	END_Mem.SetWindowText("00");
	Cycle.SetWindowText("0");
	m_port.AddString("Com1");
	m_port.AddString("Com2");
	m_port.AddString("Com3");
	m_port.AddString("Com4");
	m_baud.AddString("9600");
	m_baud.AddString("4800");
	m_baud.AddString("2400");
	m_baud.AddString("1200");
	m_port.SetCurSel(0);
	OnSelchangeCombo1();
	m_baud.SetCurSel(0);
	OnSelchangeCombo2();

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTest_PSMDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CTest_PSMDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CTest_PSMDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CTest_PSMDlg::OnSelchangeCombo1() 
{ 
	m_port.GetLBText (m_port.GetCurSel(),Port) ;
	// TODO: Add your control notification handler code here
	
}

void CTest_PSMDlg::OnSelchangeCombo2() 
{
	m_baud.GetLBText (m_baud.GetCurSel(),Baud) ;
	// TODO: Add your control notification handler code here
	
}

void CTest_PSMDlg::OnRadio1() 
{
	Comtype=1;
	// TODO: Add your control notification handler code here
	
}

void CTest_PSMDlg::OnRadio2() 
{
	Comtype=2;
	// TODO: Add your control notification handler code here
	
}

void CTest_PSMDlg::OnButton2() //Configure Interface
{
	if (Comtype==1) //Configure GPIB
	{int pad;
	CNiString userStr;
	GPIB_addr.GetWindowText(userStr);		
	userStr >> pad;
	userStr.Reset();
		if (m_device != NULL)
		{
			delete m_device;
			m_device = NULL;
		}
		try
		{
			CNi4882Address addr(pad, 0);
			m_device = new CNi4882Device(addr, 0); // Creates a CNi4882Device object
		}
		catch (CNi4882Exception* e)
		{
            e->ReportError();
			e->Delete();
		}
	}
	else if (Comtype==2) //Configure RS232
	{CComPort* pComPort = new CComPort(Port,Baud);
	pComPort->Initialize();
	pComPort->Terminate();}

	// TODO: Add your control notification handler code here
	
}

void CTest_PSMDlg::OnButton1() 
{CString cmd,s1,s2,s3;
 ST_Mem.GetWindowText(s1);
 END_Mem.GetWindowText(s2);
 Cycle.GetWindowText(s3);
	if (Comtype==1) // GPIB
	{cmd="SYST:AUTO:CEAS " +s2; //send Cease Memory
	 m_device->Write(cmd);  // Write the string to the device

	 cmd="SYST:AUTO:STAR " +s1; //send Start Memory
	 m_device->Write(cmd);  // Write the string to the device

	 cmd="SYST:AUTO:CYCL " +s3; //send Cycle
	 m_device->Write(cmd);  // Write the string to the device
	}
	else if (Comtype==2) // RS232
	{CComPort* pComPort = new CComPort(Port,Baud);
	if (pComPort->Initialize())
	{cmd="SYST:AUTO:STAR " +s1; //send Start Memory
	 pComPort->Send(cmd); 

	 cmd="SYST:AUTO:CEAS " +s2; //send Cease Memory
	 pComPort->Send(cmd); 

	 cmd="SYST:AUTO:CYCL " +s3; //send Cycle
	 pComPort->Send(cmd);

	 pComPort->Terminate();
	}
	}
	// TODO: Add your control notification handler code here
	
}

void CTest_PSMDlg::OnRadio3() 
{CString cmd;
	if (Comtype==1) // GPIB
	{
	 cmd="SYST:AUTO 1"; //Auto Running ON
	 m_device->Write(cmd);  // Write the string to the device
	}
	else if (Comtype==2) // RS232
	{CComPort* pComPort = new CComPort(Port,Baud);
	 if (pComPort->Initialize())
	 {cmd="SYST:AUTO 1"; //Auto Running ON
	  pComPort->Send(cmd); 	 pComPort->Terminate();}
    }
	 // TODO: Add your control notification handler code here
	
}

void CTest_PSMDlg::OnRadio4() 
{CString cmd;
	if (Comtype==1) // GPIB
	{
	 cmd="SYST:AUTO 0"; //Auto Running OFF
	 m_device->Write(cmd);  // Write the string to the device
	}
	else if (Comtype==2) // RS232
	{CComPort* pComPort = new CComPort(Port,Baud);
	 if (pComPort->Initialize())
	 {cmd="SYST:AUTO 0"; //Auto Running OFF
	  pComPort->Send(cmd); 	 pComPort->Terminate();}
    }
	// TODO: Add your control notification handler code here
	
}

void CTest_PSMDlg::OnRadio5() 
{CString cmd;
	if (Comtype==1) // GPIB
	{
	 cmd=":OUTP:STAT 1"; //Output ON
	 m_device->Write(cmd);  // Write the string to the device
	}
	else if (Comtype==2) // RS232
	{CComPort* pComPort = new CComPort(Port,Baud);
	 if (pComPort->Initialize())
	 {cmd=":OUTP:STAT 1"; //Output ON
	  pComPort->Send(cmd); 	 pComPort->Terminate();}
    }
	// TODO: Add your control notification handler code here
	
}

void CTest_PSMDlg::OnRadio6() 
{CString cmd;
	if (Comtype==1) // GPIB
	{
	 cmd=":OUTP:STAT 0"; //Output OFF
	 m_device->Write(cmd);  // Write the string to the device
	}
	else if (Comtype==2) // RS232
	{CComPort* pComPort = new CComPort(Port,Baud);
	 if (pComPort->Initialize())
	 {cmd=":OUTP:STAT 0"; //Output OFF
	  pComPort->Send(cmd); 	 pComPort->Terminate();}
    }
	// TODO: Add your control notification handler code here
	
}

void CTest_PSMDlg::OnChangeEdit2() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	
}

void CTest_PSMDlg::OnChangeEdit3() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	
}

void CTest_PSMDlg::OnChangeEdit4() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	
}
